#include "spacegame.h"
#include <glrenderer.h>
#include <direct.h>
#include <stdlib.h>
#include <time.h>

SpaceGame::SpaceGame(HINSTANCE &hInstance): Game(6) {
	system = new System(this, 10000.0f, 10000.0f, 0.0f);
	renderer = new GLRenderer (this, hInstance);
	compframes = 1;
	
	bool fullscreen;
	fullscreen = (MessageBox(NULL,"Game resolution is 1024 x 768. Go fullscreen?", "FullScreen",MB_YESNO|MB_ICONQUESTION)==IDYES);
	//fullscreen = false;
	renderer->initializeGraphics("Physical Asteroids", 1024, 768, 32, fullscreen, false);

	stars = new StarField(this, 100);

	_chdir("data");
	
	//player = new Spaceship(this, &keys['A'], &keys['S'], &keys['Y'], &keys['H'], &keys['G'], &keys['J']);
	//player->load("spaceship.pob", 256.0f, 512.0f);
	
	player = new Spaceship(this, &keys[VK_CONTROL], &keys[VK_SHIFT], &keys[VK_UP], &keys[VK_DOWN], &keys[VK_LEFT], &keys[VK_RIGHT]);
	player->load("spaceship.pob", 5300.0f, 1550.0f);
	
	//peteyJoe = new Pirate(this, 5500.0f, 1550.f);

	bobs = new Junkyard(this, 5000, 1000);

	srand((unsigned)time(NULL));
	for(int i = 0; i < 10; i++) {
		int x;
		int y;
		bool close = true;
		while(close) {
			close = false;
			x = rand() % ((int)(system->width) - 400) + 200;
			y = rand() % ((int)(system->height) - 400) + 200;
			Material *a;
			asteroids.begin();
			while(a = asteroids.get()) {
				a->estimateCenter();
				if(abs(a->cx - x) + abs(a->cy - y) < 1000) {
					close = true;
					break;
				}
			}
			if(abs(x - bobs->rf->x + 300) + abs(y - bobs->rf->y + 300) < 400) {
				close = true;
			}
		}
		addAsteroid(x, y, 0.0f, 0.0f, (rand() % 5) * 0.1 - 0.25);
	}
}

void SpaceGame::addAsteroid(float x, float y, float fx, float fy, float rotation) {
	Asteroid *asteroid;
	asteroid = new Asteroid(this);
	asteroid->load("smallasteroid.pob", x, y);
	asteroid->applyRotation(rotation);
	asteroid->applyForce(fx, fy);
	asteroids.add(asteroid);
}

void SpaceGame::keyDown(int key) {
	Game::keyDown(key);

	if(key == VK_PRIOR)
		compframes++;
	if(key == VK_NEXT && compframes > 1)
		compframes--;
	if(key == 'Q' || key == VK_ESCAPE)
		quit = true;
	if(key == VK_SPACE)
		paused = !paused;
}

void SpaceGame::stepFunc() {
	Game::stepFunc();

	//ADD GAME CODE HERE
}

#include <glfuncs.h>

void SpaceGame::predraw() {
	player->calculateCenter();
	offx = player->cx - renderer->windoww * 0.5f;
	offy = player->cy - renderer->windowh * 0.5f;

	glTranslatef(-offx, -offy, 0);

	//glRasterPos2d(10, 10);
	//glPrint("Hello World!");
	stars->draw(offx, offy, renderer->windoww, renderer->windowh);
}

void SpaceGame::draw() {

	Object::draw();
	
	glColor4f(1.0f, 0.0f, 0.0f, 1.0f);
	glLineWidth(2.0f);
	glBegin(GL_LINE_LOOP);
		glVertex3f(0.0f, 0.0f, 2.0f);
		glVertex3f(system->width, 0.0f, 2.0f);
		glVertex3f(system->width, system->height, 2.0f);
		glVertex3f(0.0f, system->height, 2.0f);
	glEnd();

	float mindist = 999999999.0f;
	float moffx, moffy;
	float pdist, dist;
	Material *min = NULL;
	Material *a;
	asteroids.begin();
	while(a = asteroids.get()) {
		if(a->polys.length() > 10) {
			a->estimateCenter();
			offx = a->cx - player->cx;
			offy = a->cy - player->cy;
			dist = offx * offx + offy * offy;
			if(dist < mindist) {
				mindist = dist;
				moffx = offx;
				moffy = offy;
				min = a;
			}
		}
	}
	if(min && mindist > 150000) {
		pdist = 1.0f / sqrt(mindist);
		dist = pdist + sqrt(sqrt(mindist)) / 200000.0f;
		if(dist > 1.7f * pdist) dist = 1.7f * pdist;
		glColor3f(0.0f, 1.0f, 0.0f);
		glBegin(GL_LINES);
			glVertex3f(player->cx + 150.0f * pdist * moffx, player->cy + 150.0f * pdist * moffy, 0.0f);
			glVertex3f(player->cx + 200.0f * dist * moffx, player->cy + 200.0f * dist * moffy, 0.0f);
		glEnd();
	}

	offx = (bobs->rf->x + 360) - player->cx;
	offy = (bobs->rf->y + 315) - player->cy;
	mindist = offx * offx + offy * offy;

	if(mindist > 100000) {
		pdist = 1.0f / sqrt(mindist);
		dist = pdist + sqrt(sqrt(mindist)) / 200000.0f;
		if(dist > 1.7f * pdist) dist = 1.7f * pdist;
		glColor3f(1.0f, 0.0f, 0.0f);
		glBegin(GL_LINES);
			glVertex3f(player->cx + 150.0f * pdist * offx, player->cy + 150.0f * pdist * offy, 0.0f);
			glVertex3f(player->cx + 200.0f * dist * offx, player->cy + 200.0f * dist * offy, 0.0f);
		glEnd();
	}

	//glTranslatef(offx, offy, 0);
	//glRasterPos2f(-offx + 10, -offy + 10);
	//glPrint("Hello World!");
	//glTranslatef(-offx, -offy, 0);
}
